/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.marcoverride;

import java.io.InputStream;
import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.MarcXmlReader;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class MarcUnprettyXmlReader
implements MarcReader {
    private MarcXmlReader reader = null;

    public MarcUnprettyXmlReader(InputStream input) {
        this.reader = new MarcXmlReader(input);
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Record next() {
        Record rec = this.reader.next();
        rec.getLeader().setCharCodingScheme('a');
        List<VariableField> varFields = rec.getVariableFields();
        for (VariableField f : varFields) {
            if (f instanceof ControlField) {
                ControlField cf = (ControlField)f;
                String data = cf.getData();
                if (!data.contains("\n")) continue;
                data = data.replaceAll("\\r?\\n[ \t]*", " ");
                data = data.trim();
                cf.setData(data);
                continue;
            }
            if (!(f instanceof DataField)) continue;
            DataField df = (DataField)f;
            List<Subfield> subFields = df.getSubfields();
            for (Subfield s : subFields) {
                Subfield sf = s;
                String data = sf.getData();
                if (!data.contains("\n")) continue;
                data = data.replaceAll("\\r?\\n[ \t]*", " ");
                data = data.trim();
                sf.setData(data);
            }
        }
        return rec;
    }
}

