/*
 * Decompiled with CFR 0.152.
 */
package org.solrmarc.marcoverride;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.marc4j.MarcException;
import org.marc4j.MarcStreamWriter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;

public class MarcSplitStreamWriter
extends MarcStreamWriter {
    private int recordThreshhold;
    private String fieldsToSplit;

    public MarcSplitStreamWriter(OutputStream out, int threshhold, String fieldsToSplit) {
        super(out, false);
        this.recordThreshhold = threshhold;
        this.fieldsToSplit = fieldsToSplit;
    }

    public MarcSplitStreamWriter(OutputStream out, String encoding, int threshhold, String fieldsToSplit) {
        super(out, encoding, false);
        this.recordThreshhold = threshhold;
        this.fieldsToSplit = fieldsToSplit;
    }

    @Override
    public void write(Record record) {
        boolean doneWithRec = false;
        List<VariableField> fields = record.getDataFields();
        for (DataField dataField : fields) {
            if (!dataField.getTag().matches(this.fieldsToSplit)) continue;
            dataField.setId(null);
        }
        while (!doneWithRec) {
            try {
                int n;
                List<Subfield> subfields;
                boolean bl = false;
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                ByteArrayOutputStream dir = new ByteArrayOutputStream();
                fields = record.getControlFields();
                for (ControlField controlField : fields) {
                    int n2;
                    data.write(this.getDataElement(controlField.getData()));
                    data.write(30);
                    dir.write(this.getEntry(controlField.getTag(), data.size() - n2, n2));
                    n2 = data.size();
                }
                fields = record.getDataFields();
                for (DataField dataField : fields) {
                    int n3;
                    if (dataField.getTag().matches(this.fieldsToSplit)) continue;
                    data.write(dataField.getIndicator1());
                    data.write(dataField.getIndicator2());
                    subfields = dataField.getSubfields();
                    for (Subfield sf : subfields) {
                        data.write(31);
                        data.write(sf.getCode());
                        data.write(this.getDataElement(sf.getData()));
                    }
                    data.write(30);
                    dir.write(this.getEntry(dataField.getTag(), data.size() - n3, n3));
                    n3 = data.size();
                }
                fields = record.getDataFields();
                Iterator<VariableField> i = fields.iterator();
                while (i.hasNext() && n < this.recordThreshhold) {
                    DataField dataField = (DataField)i.next();
                    if (!dataField.getTag().matches(this.fieldsToSplit) || dataField.getId() != null && dataField.getId().intValue() == 0) continue;
                    dataField.setId(new Long(0L));
                    data.write(dataField.getIndicator1());
                    data.write(dataField.getIndicator2());
                    subfields = dataField.getSubfields();
                    for (Subfield sf : subfields) {
                        data.write(31);
                        data.write(sf.getCode());
                        data.write(this.getDataElement(sf.getData()));
                    }
                    data.write(30);
                    dir.write(this.getEntry(dataField.getTag(), data.size() - n, n));
                    n = data.size();
                }
                if (!i.hasNext()) {
                    doneWithRec = true;
                }
                dir.write(30);
                Leader leader = record.getLeader();
                int baseAddress = 24 + dir.size();
                leader.setBaseAddressOfData(baseAddress);
                int recordLength = leader.getBaseAddressOfData() + data.size() + 1;
                leader.setRecordLength(recordLength);
                dir.close();
                data.close();
                if (!this.allowOversizeEntry && this.hasOversizeLength) {
                    throw new MarcException("Record has field that is too long to be a valid MARC binary record. The maximum length for a field counting all of the sub-fields is 9999 bytes.");
                }
                this.writeLeader(leader);
                this.out.write(dir.toByteArray());
                this.out.write(data.toByteArray());
                this.out.write(29);
            }
            catch (IOException iOException) {
                throw new MarcException("IO Error occured while writing record", iOException);
            }
            catch (MarcException marcException) {
                throw marcException;
            }
        }
    }
}

