/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.marc4j.util.RawRecord;

public class RawRecordReader {
    private DataInputStream input;
    RawRecord nextRec = null;
    RawRecord afterNextRec = null;
    boolean mergeRecords = true;

    public RawRecordReader(InputStream is) {
        this.input = new DataInputStream(new BufferedInputStream(is));
    }

    public RawRecordReader(InputStream is, boolean mergeRecords) {
        this.mergeRecords = mergeRecords;
        this.input = new DataInputStream(new BufferedInputStream(is));
    }

    public boolean hasNext() {
        if (this.nextRec == null) {
            this.nextRec = new RawRecord(this.input);
        }
        if (this.nextRec != null && this.nextRec.getRecordBytes() != null) {
            if (this.afterNextRec == null) {
                this.afterNextRec = new RawRecord(this.input);
                if (this.mergeRecords) {
                    while (this.afterNextRec != null && this.afterNextRec.getRecordBytes() != null && this.afterNextRec.getRecordId().equals(this.nextRec.getRecordId())) {
                        this.nextRec = new RawRecord(this.nextRec, this.afterNextRec);
                        this.afterNextRec = new RawRecord(this.input);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public RawRecord next() {
        RawRecord tmpRec = this.nextRec;
        this.nextRec = this.afterNextRec;
        this.afterNextRec = null;
        return tmpRec;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Error: No records specified for extraction");
        }
        try {
            int numToSkip = 0;
            int numToOutput = -1;
            int offset = 0;
            RawRecordReader reader = args[offset].equals("-") ? new RawRecordReader(System.in) : new RawRecordReader(new FileInputStream(new File(args[offset])));
            ++offset;
            while (offset < args.length && (args[offset].equals("-skip") || args[offset].equals("-num"))) {
                if (args[offset].equals("-skip")) {
                    numToSkip = Integer.parseInt(args[offset + 1]);
                    offset += 2;
                    continue;
                }
                if (!args[offset].equals("-num")) continue;
                numToOutput = Integer.parseInt(args[offset + 1]);
                offset += 2;
            }
            if (numToSkip != 0 || numToOutput != -1) {
                RawRecordReader.processInput(reader, numToSkip, numToOutput);
            } else if (args[offset].equals("-id")) {
                RawRecordReader.printIds(reader);
            } else if (args[offset].equals("-h") && args.length >= 3) {
                String idRegex = args[offset + 1].trim();
                RawRecordReader.processInput(reader, null, idRegex, null);
            } else if (!args[offset].endsWith(".txt")) {
                String idRegex = args[offset].trim();
                RawRecordReader.processInput(reader, idRegex, null, null);
            } else {
                String line;
                File idList = new File(args[offset]);
                BufferedReader idStream = new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(idList))));
                String[] findReplace = null;
                if (args.length > 2) {
                    findReplace = args[2].split("->");
                }
                LinkedHashSet<String> idsLookedFor = new LinkedHashSet<String>();
                while ((line = idStream.readLine()) != null) {
                    if (findReplace != null) {
                        line = line.replaceFirst(findReplace[0], findReplace[1]);
                    }
                    idsLookedFor.add(line);
                }
                idStream.close();
                RawRecordReader.processInput(reader, null, null, idsLookedFor);
            }
        }
        catch (EOFException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void processInput(RawRecordReader reader, int numToSkip, int numToOutput) throws IOException {
        int num = 0;
        int numOutput = 0;
        while (reader.hasNext()) {
            RawRecord rec = reader.next();
            if (++num <= numToSkip || numToOutput != -1 && numOutput >= numToOutput) continue;
            byte[] recordBytes = rec.getRecordBytes();
            System.out.write(recordBytes);
            System.out.flush();
            ++numOutput;
        }
    }

    static void printIds(RawRecordReader reader) throws IOException {
        while (reader.hasNext()) {
            RawRecord rec = reader.next();
            String id = rec.getRecordId();
            System.out.println(id);
        }
    }

    static void processInput(RawRecordReader reader, String idRegex, String recordHas, HashSet<String> idsLookedFor) throws IOException {
        while (reader.hasNext()) {
            String tag;
            String field;
            RawRecord rec = reader.next();
            String id = rec.getRecordId();
            if (idsLookedFor == null && recordHas == null && id.matches(idRegex) || idsLookedFor != null && idsLookedFor.contains(id)) {
                byte[] recordBytes = rec.getRecordBytes();
                System.out.write(recordBytes);
                System.out.flush();
                continue;
            }
            if (idsLookedFor != null || idRegex != null || recordHas == null || (field = rec.getFieldVal(tag = recordHas.substring(0, 3))) == null) continue;
            byte[] recordBytes = rec.getRecordBytes();
            System.out.write(recordBytes);
            System.out.flush();
        }
    }
}

