/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.marc4j.MarcPermissiveStreamReader;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;

public class RawRecord {
    String id;
    byte[] rawRecordData;
    byte[] leader = null;

    public RawRecord(DataInputStream ds) {
        this.init(ds);
        if (this.rawRecordData != null) {
            this.id = this.getRecordId();
        }
    }

    private void init(DataInputStream ds) {
        this.id = null;
        ds.mark(24);
        if (this.leader == null) {
            this.leader = new byte[24];
        }
        try {
            ds.readFully(this.leader);
            int length = RawRecord.parseRecordLength(this.leader);
            ds.reset();
            ds.mark(length * 2);
            this.rawRecordData = new byte[length];
            try {
                ds.readFully(this.rawRecordData);
            }
            catch (EOFException e) {
                int c;
                ds.reset();
                int cnt = 0;
                while ((c = ds.read()) != -1) {
                    this.rawRecordData[cnt++] = (byte)c;
                }
                int location = RawRecord.byteArrayContains(this.rawRecordData, 29);
                if (location != -1) {
                    length = location + 1;
                }
                throw e;
            }
            if (this.rawRecordData[length - 1] != 29) {
                int location = RawRecord.byteArrayContains(this.rawRecordData, 29);
                if (location != -1) {
                    ds.reset();
                    this.rawRecordData = new byte[location];
                    ds.readFully(this.rawRecordData);
                } else {
                    int numRead;
                    ArrayList<Byte> recBuf = new ArrayList<Byte>();
                    ds.reset();
                    byte[] byteRead = new byte[1];
                    while ((numRead = ds.read(byteRead)) != -1) {
                        recBuf.add(byteRead[0]);
                        if (byteRead[0] != 29) continue;
                        break;
                    }
                    this.rawRecordData = new byte[recBuf.size()];
                    for (int i = 0; i < recBuf.size(); ++i) {
                        this.rawRecordData[i] = (Byte)recBuf.get(i);
                    }
                }
            }
        }
        catch (IOException e) {
            try {
                this.rawRecordData = null;
                ds.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static int byteArrayContains(byte[] data, int value) {
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public RawRecord(RawRecord rec1, RawRecord rec2) {
        this.rawRecordData = new byte[rec1.getRecordBytes().length + rec2.getRecordBytes().length];
        System.arraycopy(rec1.getRecordBytes(), 0, this.rawRecordData, 0, rec1.getRecordBytes().length);
        System.arraycopy(rec2.getRecordBytes(), 0, this.rawRecordData, rec1.getRecordBytes().length, rec2.getRecordBytes().length);
        this.id = this.getRecordId();
    }

    public String getRecordId() {
        if (this.id != null) {
            return this.id;
        }
        this.id = this.getFieldVal("001");
        return this.id;
    }

    public String getFieldVal(String idField) {
        String recordStr = null;
        try {
            recordStr = new String(this.rawRecordData, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        int offset = Integer.parseInt(recordStr.substring(12, 17));
        int dirOffset = 24;
        String fieldNum = recordStr.substring(dirOffset, dirOffset + 3);
        while (dirOffset < offset) {
            if (fieldNum.equals(idField)) {
                int length = Integer.parseInt(recordStr.substring(dirOffset + 3, dirOffset + 7));
                int offset2 = Integer.parseInt(recordStr.substring(dirOffset + 7, dirOffset + 12));
                String id = recordStr.substring(offset + offset2, offset + offset2 + length - 1).trim();
                return id;
            }
            fieldNum = recordStr.substring(dirOffset += 12, dirOffset + 3);
        }
        return null;
    }

    public byte[] getRecordBytes() {
        return this.rawRecordData;
    }

    public Record getAsRecord(boolean permissive, boolean toUtf8, String combinePartials, String defaultEncoding) {
        ByteArrayInputStream bais = new ByteArrayInputStream(this.rawRecordData);
        MarcPermissiveStreamReader reader = new MarcPermissiveStreamReader((InputStream)bais, permissive, toUtf8, defaultEncoding);
        Record next = reader.next();
        if (combinePartials != null) {
            while (reader.hasNext()) {
                Record nextNext = reader.next();
                List<VariableField> fieldsAll = nextNext.getVariableFields();
                for (VariableField vf : fieldsAll) {
                    if (!combinePartials.contains(vf.getTag())) continue;
                    next.addVariableField(vf);
                }
            }
        }
        return next;
    }

    private static int parseRecordLength(byte[] leaderData) throws IOException {
        InputStreamReader isr = new InputStreamReader(new ByteArrayInputStream(leaderData));
        int length = -1;
        char[] tmp = new char[5];
        isr.read(tmp);
        try {
            length = Integer.parseInt(new String(tmp));
        }
        catch (NumberFormatException e) {
            throw new IOException("unable to parse record length");
        }
        return length;
    }
}

