/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Normalizer {
    private static Class<?> normalizerInAvailableJar = null;
    private static Class<?> normalizerFormClass = null;
    private static boolean hasJavaTextNormalizer = false;
    private static Method composeMethod = null;
    private static Method decomposeMethod = null;
    private static Method normalizeMethod = null;
    public static int NONE = 1;
    public static int NFD = 2;
    public static int NFKD = 3;
    public static int NFC = 4;
    public static int NFKC = 5;
    public static Object NFD_obj = null;
    public static Object NFKD_obj = null;
    public static Object NFC_obj = null;
    public static Object NFKC_obj = null;

    private Normalizer() {
    }

    public static String normalize(String str, int mode) {
        String result = str;
        if (normalizerInAvailableJar == null) {
            Normalizer.initializeNormalizer();
        }
        try {
            result = hasJavaTextNormalizer ? (mode == NFD ? normalizeMethod.invoke(null, str, NFD_obj).toString() : (mode == NFC ? normalizeMethod.invoke(null, str, NFC_obj).toString() : (mode == NFKD ? normalizeMethod.invoke(null, str, NFKD_obj).toString() : (mode == NFKC ? normalizeMethod.invoke(null, str, NFKC_obj).toString() : str)))) : (mode == NFD ? decomposeMethod.invoke(null, str, false).toString() : (mode == NFC ? composeMethod.invoke(null, str, false).toString() : (mode == NFKD ? decomposeMethod.invoke(null, str, true).toString() : (mode == NFKC ? composeMethod.invoke(null, str, true).toString() : str))));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return result;
    }

    private static void initializeNormalizer() {
        try {
            normalizerInAvailableJar = Class.forName("java.text.Normalizer");
            hasJavaTextNormalizer = true;
            normalizerFormClass = Class.forName("java.text.Normalizer$Form");
            normalizeMethod = normalizerInAvailableJar.getMethod("normalize", CharSequence.class, normalizerFormClass);
            Method valueOf = normalizerFormClass.getMethod("valueOf", String.class);
            NFD_obj = valueOf.invoke(null, "NFD");
            NFKD_obj = valueOf.invoke(null, "NFKD");
            NFC_obj = valueOf.invoke(null, "NFC");
            NFKC_obj = valueOf.invoke(null, "NFKC");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                normalizerInAvailableJar = Class.forName("com.ibm.icu.text.Normalizer");
            }
            catch (ClassNotFoundException e) {
                try {
                    normalizerInAvailableJar = Class.forName("com.solrmarc.icu.text.Normalizer");
                }
                catch (ClassNotFoundException e1) {
                    throw new RuntimeException(e);
                }
            }
            try {
                composeMethod = normalizerInAvailableJar.getMethod("compose", String.class, Boolean.TYPE);
                decomposeMethod = normalizerInAvailableJar.getMethod("decompose", String.class, Boolean.TYPE);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

