/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.util;

import java.io.BufferedInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class JsonParser {
    private final boolean optEolIsComma;
    private final boolean optInternKeywords;
    private final boolean optInternValues;
    private final boolean optMultilineComments;
    private final boolean optMultilineStrings;
    private final boolean optSingleQuoteStrings;
    private final boolean optPreloadInput;
    private final boolean optUnquotedKeywords;
    private final ArrayList<ObjectData> objectStack;
    private final StringBuilder accumulator;
    private String inpName;
    private Reader inpReader;
    private boolean inpClose;
    private int inpLine;
    private int inpColumn;
    private ObjectData objectData;
    private int pushBack;
    private int evtCode;
    private int evtLine;
    private int evtColumn;
    private String mbrName;
    private String mbrValue;
    public static final int EVT_OBJECT_BEGIN = 1;
    public static final int EVT_OBJECT_ENDED = 2;
    public static final int EVT_ARRAY_BEGIN = 3;
    public static final int EVT_ARRAY_ENDED = 4;
    public static final int EVT_INPUT_ENDED = 5;
    public static final int EVT_OBJECT_MEMBER = 6;
    private static String[] EVT_NAMES = new String[]{"Invalid", "ObjectBegin", "ObjectEnded", "ArrayBegin", "ArrayEnded", "InputEnded", "ObjectMember"};
    public static final int OPT_UNQUOTED_KEYWORDS = 1;
    public static final int OPT_EOL_IS_COMMA = 2;
    public static final int OPT_MULTILINE_COMMENTS = 4;
    public static final int OPT_MULTILINE_STRINGS = 8;
    public static final int OPT_SINGLE_QUOTE_STRINGS = 16;
    public static final int OPT_PRELOAD_INPUT = 0x20000000;
    public static final int OPT_INTERN_KEYWORDS = 0x40000000;
    public static final int OPT_INTERN_VALUES = Integer.MIN_VALUE;
    public static final int OPT_STRICT = 0;
    public static final int OPT_MESSAGING = 0x40000001;
    public static final int OPT_CONFIG = -1073741801;
    public static final int OPT_ALL = -1;
    static int[] decodeHex = new int[256];

    public JsonParser(int opt) {
        this.optEolIsComma = (opt & 2) != 0;
        this.optInternKeywords = (opt & 0x40000000) != 0;
        this.optInternValues = (opt & Integer.MIN_VALUE) != 0;
        this.optMultilineComments = (opt & 4) != 0;
        this.optMultilineStrings = (opt & 8) != 0;
        this.optSingleQuoteStrings = (opt & 0x10) != 0;
        this.optPreloadInput = (opt & 0x20000000) != 0;
        this.optUnquotedKeywords = (opt & 1) != 0;
        this.objectStack = new ArrayList();
        this.accumulator = new StringBuilder();
        this.reset(true);
    }

    public void close() {
        this.reset(true);
    }

    public void reset() {
        this.reset(false);
    }

    private void reset(boolean all) {
        if (this.inpClose && this.inpReader != null) {
            try {
                this.inpReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.objectStack.clear();
        this.accumulator.setLength(0);
        if (all) {
            this.accumulator.trimToSize();
        }
        this.inpName = null;
        this.inpReader = null;
        this.inpLine = 1;
        this.inpColumn = 0;
        this.objectData = new ObjectData("");
        this.pushBack = -1;
        this.evtCode = 0;
        this.evtLine = 0;
        this.evtColumn = 0;
        this.mbrName = "";
        this.mbrValue = "";
    }

    public String getInputName() {
        return this.inpName;
    }

    public Location getInputLocation() {
        return this.createLocation(this.inpLine, this.inpColumn);
    }

    public String getObjectName() {
        return this.objectData.name;
    }

    public int getEventCode() {
        return this.evtCode;
    }

    public String getEventName() {
        return JsonParser.getEventName(this.evtCode);
    }

    public int getEventLine() {
        return this.evtLine;
    }

    public int getEventColumn() {
        return this.evtColumn;
    }

    public Location getEventLocation() {
        return this.createLocation(this.evtLine, this.evtColumn);
    }

    public String getMemberName() {
        return this.mbrName;
    }

    public String getMemberValue() {
        return this.mbrValue;
    }

    public boolean getMemberArray() {
        return this.objectData.arrayDepth != 0;
    }

    public static Object getTypedMemberValue(String val) {
        return JsonParser.createTypedValue(val);
    }

    public JsonParser setInput(String inpnam, Reader inpsrc, boolean inpcls) {
        this.reset(false);
        this.inpName = inpnam;
        this.inpReader = inpsrc;
        this.inpClose = inpcls;
        if (this.optPreloadInput) {
            this.inpReader = JsonParser.preloadInput(inpnam, this.inpReader, this.inpClose, 0);
            this.inpClose = true;
        }
        return this;
    }

    public JsonParser setInput(String inpnam, InputStream inpsrc, String inpenc, boolean inpcls) {
        this.reset(false);
        this.inpName = inpnam;
        try {
            this.inpReader = new InputStreamReader(inpsrc, inpenc);
        }
        catch (UnsupportedEncodingException thr) {
            throw new Escape(3, "The encoding '" + inpenc + "' is not supported by this Java Runtime Engine");
        }
        this.inpClose = inpcls;
        if (this.optPreloadInput) {
            this.inpReader = JsonParser.preloadInput(inpnam, this.inpReader, this.inpClose, 0);
            this.inpClose = true;
        }
        return this;
    }

    public JsonParser setInput(String inpfil, String inpenc, int bufsiz) {
        this.reset(false);
        this.inpName = inpfil;
        try {
            this.inpReader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(inpfil), bufsiz), inpenc);
        }
        catch (UnsupportedEncodingException thr) {
            throw new Escape(3, "The encoding '" + inpenc + "' is not supported by this Java Runtime Engine", thr);
        }
        catch (IOException thr) {
            throw new Escape(2, "Could not access file \"" + inpfil + "\": " + thr, thr);
        }
        this.inpClose = true;
        if (this.optPreloadInput) {
            this.inpReader = JsonParser.preloadInput(inpfil, this.inpReader, this.inpClose, Math.min(Integer.MAX_VALUE, (int)new File(inpfil).length()));
            this.inpClose = true;
        }
        return this;
    }

    public JsonParser setInput(File inpfil, String inpenc, int bufsiz) {
        this.reset(false);
        this.inpName = inpfil.toString();
        try {
            this.inpReader = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(inpfil), bufsiz), inpenc);
        }
        catch (UnsupportedEncodingException thr) {
            throw new Escape(3, "The encoding '" + inpenc + "' is not supported by this Java Runtime Engine", thr);
        }
        catch (IOException thr) {
            throw new Escape(2, "Could not access file \"" + inpfil + "\": " + thr, thr);
        }
        this.inpClose = true;
        if (this.optPreloadInput) {
            this.inpReader = JsonParser.preloadInput(inpfil.toString(), this.inpReader, this.inpClose, Math.min(Integer.MAX_VALUE, (int)inpfil.length()));
            this.inpClose = true;
        }
        return this;
    }

    public int next() {
        try {
            if (this.evtCode != 5) {
                int ich;
                int pet = this.evtCode;
                boolean qut = false;
                boolean squ = false;
                boolean amd = true;
                boolean pws = false;
                this.evtCode = 0;
                this.evtLine = 0;
                this.evtColumn = 0;
                if (pet == 1) {
                    this.mbrName = "";
                } else if (pet == 2) {
                    this.popObjectData();
                } else if (pet == 4) {
                    this.mbrName = "";
                } else if (pet == 6) {
                    this.mbrName = "";
                }
                this.mbrValue = null;
                block26: while ((ich = this.readChar()) != -1) {
                    if (!qut) {
                        if (ich == 42 || ich == 35) {
                            while ((ich = this.readChar()) != -1 && ich != 10) {
                            }
                        } else if (ich == 47) {
                            int tmp = this.readChar();
                            if (tmp == 47) {
                                while ((ich = this.readChar()) != -1 && ich != 10) {
                                }
                            } else if (tmp == 42) {
                                if (!this.optMultilineComments) {
                                    throw this.parserError(4, "Multiline comment not permitted by parser", null, this.evtLine, this.evtColumn);
                                }
                                while ((tmp = this.readChar()) != -1 && (tmp != 42 || (tmp = this.readChar()) != 47)) {
                                }
                                if (tmp != 47) {
                                    throw this.parserError(4, "Multiline comment not closed before EOF", null, this.evtLine, this.evtColumn);
                                }
                                ich = 32;
                            } else {
                                this.unreadChar(tmp);
                                ich = 47;
                            }
                        }
                        if (ich == -1) break;
                    }
                    if (ich == 92) {
                        int lin = this.inpLine;
                        int col = this.inpColumn;
                        ich = this.readChar();
                        if (ich == -1) {
                            throw this.parserError(6, "The input stream ended with an incomplete escape sequence", null, lin, col);
                        }
                        switch (ich) {
                            case 34: {
                                this.storeChar('\"');
                                continue block26;
                            }
                            case 92: {
                                this.storeChar('\\');
                                continue block26;
                            }
                            case 47: {
                                this.storeChar('\u2044');
                                continue block26;
                            }
                            case 98: {
                                this.storeChar('\b');
                                continue block26;
                            }
                            case 102: {
                                this.storeChar('\f');
                                continue block26;
                            }
                            case 110: {
                                this.storeChar('\n');
                                continue block26;
                            }
                            case 114: {
                                this.storeChar('\r');
                                continue block26;
                            }
                            case 116: {
                                this.storeChar('\t');
                                continue block26;
                            }
                            case 117: {
                                int ic1 = this.readChar();
                                int ic2 = this.readChar();
                                int ic3 = this.readChar();
                                int ic4 = this.readChar();
                                if (ic4 == -1) {
                                    throw this.parserError(6, "The input stream ended with an incomplete escape sequence", null, lin, col);
                                }
                                this.storeChar((char)this.decodeHexChar((char)ic1, (char)ic2, (char)ic3, (char)ic4, lin, col));
                                continue block26;
                            }
                            case 120: {
                                int ic1 = this.readChar();
                                int ic2 = this.readChar();
                                if (ic2 == -1) {
                                    throw this.parserError(6, "The input stream ended with an incomplete escape sequence", null, lin, col);
                                }
                                this.storeChar((char)this.decodeHexByte((char)ic1, (char)ic2, lin, col));
                                continue block26;
                            }
                        }
                        throw this.parserError(6, "The text string contains the invalid escape sequence '\\" + (char)ich, null, lin, col);
                    }
                    if (qut) {
                        if (ich < 32 && (!this.optMultilineStrings || ich != 13 && ich != 10)) {
                            throw this.parserError(4, "A quoted literal may not contain any control characters" + (this.optMultilineStrings ? " except CR and LF" : "") + " - controls must be escaped using \\uHHHH");
                        }
                        if (!squ && ich == 34 || squ && ich == 39) {
                            qut = false;
                            amd = false;
                        }
                        this.storeChar((char)ich);
                        continue;
                    }
                    if (!this.optEolIsComma && (ich == 13 || ich == 10)) continue;
                    if (ich == 34 || this.optSingleQuoteStrings && ich == 39) {
                        if (this.accumulator.length() != 0) {
                            throw this.parserError(4, "Text was found preceding an unescaped opening quote: \"" + this.accumulator + "\" (this is usually caused by a missing colon, a missing comma or missing quotes); Text=\"" + this.accumulator.toString() + "\"");
                        }
                        if (!amd) {
                            throw this.parserError(4, "A string value cannot contain unescaped quotes (this is usually caused by a missing comma between members)");
                        }
                        qut = true;
                        squ = ich == 39;
                        this.storeChar((char)ich);
                        continue;
                    }
                    switch (ich) {
                        case 58: {
                            if (this.mbrName.length() > 0) {
                                throw this.parserError(4, "An object member value contained a colon but was not enclosed in quotes (this can often be caused by a missing comma between members)");
                            }
                            if (this.objectData.arrayDepth != 0) {
                                throw this.parserError(4, "An array element cannot be a Name:Value pair - it must be only a value (this is most likely caused by misplaced or missing closing bracket)");
                            }
                            String txt = this.getAccumulatedText(true);
                            if (txt.length() == 0) {
                                throw this.parserError(4, "An object member name cannot be blank");
                            }
                            this.mbrName = JsonParser.stripQuotes(txt);
                            amd = true;
                            if (this.optUnquotedKeywords || JsonParser.isQuoted(txt)) continue block26;
                            throw this.parserError(4, "An object member name was not enclosed in quotes");
                        }
                        case 10: 
                        case 13: 
                        case 44: {
                            if (this.accumulator.length() != 0) {
                                if (pet == 2) {
                                    throw this.parserError(4, "Text was found between an object's closing brace and a subsequent comma or end of line (this is usually caused by a missing comma); Text=\"" + this.accumulator.toString() + "\"");
                                }
                                if (pet == 4) {
                                    throw this.parserError(4, "Text was found between an array's closing bracket and a subsequent comma (this is usually caused by a missing comma); Text=\"" + this.accumulator.toString() + "\"");
                                }
                                if (this.objectData.arrayDepth == 0 && this.mbrName.length() == 0) {
                                    throw this.parserError(4, "Object member name or value is missing in a Name:Value pair (this is possibly caused by missing array brackets in an array)");
                                }
                                if (this.objectData.arrayDepth != 0) {
                                    this.mbrName = this.objectData.arrayName;
                                }
                                this.mbrValue = this.getAccumulatedText(false);
                                this.evtCode = 6;
                                return 6;
                            }
                            this.mbrName = "";
                            pet = 6;
                            amd = true;
                            continue block26;
                        }
                        case 123: {
                            if (this.accumulator.length() != 0) {
                                throw this.parserError(4, "Text was found preceding an object's opening brace (this is usually caused by a missing comma or colon, or by using equals instead of a colon); Text=\"" + this.accumulator.toString() + "\"");
                            }
                            this.pushObjectData();
                            if (this.objectData.arrayDepth != 0) {
                                this.mbrName = this.objectData.arrayName;
                            }
                            this.objectData = new ObjectData(this.mbrName);
                            this.evtCode = 1;
                            return 1;
                        }
                        case 125: {
                            this.mbrValue = this.getAccumulatedText(false);
                            if (this.objectData.arrayDepth == 0 && this.mbrName.length() == 0 && this.mbrValue.length() > 0) {
                                throw this.parserError(4, "Object member name or value is missing in a Name:Value pair (this is possibly caused by missing array brackets in an array)");
                            }
                            if (this.mbrValue.length() > 0) {
                                this.unreadChar(ich);
                                if (this.objectData.arrayDepth != 0) {
                                    this.mbrName = this.objectData.arrayName;
                                }
                                this.evtCode = 6;
                                return 6;
                            }
                            this.mbrName = this.objectData.name;
                            this.evtCode = 2;
                            return 2;
                        }
                        case 91: {
                            if (this.accumulator.length() != 0) {
                                throw this.parserError(4, "Text was found preceding an array's opening bracket (this is usually caused by a missing comma or colon, or by using equals instead of a colon); Text=\"" + this.accumulator.toString() + "\"");
                            }
                            if (this.objectData.arrayDepth == 0) {
                                this.objectData.arrayName = this.mbrName;
                            } else {
                                this.mbrName = this.objectData.arrayName;
                            }
                            ++this.objectData.arrayDepth;
                            this.evtCode = 3;
                            return 3;
                        }
                        case 93: {
                            if (this.objectData.arrayDepth == 0) {
                                throw this.parserError(4, "Extraneous closing array bracket detected (this is usually caused by a missing opening array bracket)");
                            }
                            this.mbrValue = this.getAccumulatedText(false);
                            if (this.mbrValue.length() > 0) {
                                this.unreadChar(ich);
                                if (this.objectData.arrayDepth != 0) {
                                    this.mbrName = this.objectData.arrayName;
                                }
                                this.evtCode = 6;
                                return 6;
                            }
                            --this.objectData.arrayDepth;
                            this.mbrName = this.objectData.arrayName;
                            if (this.objectData.arrayDepth == 0) {
                                this.objectData.arrayName = "";
                            }
                            this.evtCode = 4;
                            return 4;
                        }
                    }
                    if (Character.isWhitespace((char)ich)) {
                        pws = true;
                        continue;
                    }
                    if (!amd) {
                        throw this.parserError(4, "A string value cannot contain data after its closing quote (this is most likely caused by a missing comma between members)");
                    }
                    if (pws && this.accumulator.length() != 0) {
                        throw this.parserError(4, "Text with embedded spaces was found but not enclosed in quotes (this is often caused by a missing comma following an unquoted value); Text=\"" + this.accumulator.toString() + "\"");
                    }
                    this.storeChar((char)ich);
                    pws = false;
                }
                this.mbrName = null;
                this.mbrValue = null;
                if (this.objectStack.size() != 0) {
                    if (qut) {
                        throw this.parserError(4, "A string's closing quote was missing from the input data (end of input was reached before string was terminated)");
                    }
                    throw this.parserError(4, "An object's closing brace was missing from the input data (end of input was reached before object was terminated)");
                }
                if (this.objectData.arrayDepth != 0) {
                    throw this.parserError(4, "Array named '" + this.objectData.arrayName + "' was not ended (end of input was reached before array was terminated)");
                }
                this.evtLine = this.inpLine;
                this.evtColumn = this.inpColumn;
                if (this.inpClose) {
                    try {
                        this.inpReader.close();
                    }
                    catch (Throwable ign) {
                        // empty catch block
                    }
                }
            }
            this.evtCode = 5;
            return 5;
        }
        catch (IOException thr) {
            if (this.inpClose) {
                try {
                    this.inpReader.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new Escape(2, "I/O Exception: " + thr, thr);
        }
    }

    public void skipObject() {
        if (this.getEventCode() != 1) {
            throw this.parserError(7, "An object can only be skipped when the current event is EVT_OBJECT_BEGIN");
        }
        int level = 1;
        while (level > 0) {
            int eventCode = this.next();
            if (eventCode == 1) {
                ++level;
                continue;
            }
            if (eventCode != 2) continue;
            --level;
        }
    }

    public void skipArray() {
        if (this.getEventCode() != 3) {
            throw this.parserError(7, "An object can only be skipped when the current event is EVT_ARRAY_BEGIN");
        }
        int level = 1;
        while (level > 0) {
            int eventCode = this.next();
            if (eventCode == 3) {
                ++level;
                continue;
            }
            if (eventCode == 4) {
                --level;
                continue;
            }
            if (eventCode != 1) continue;
            this.skipObject();
        }
    }

    private void storeChar(char ch) {
        if (this.evtLine == 0) {
            this.evtLine = this.inpLine;
            this.evtColumn = this.inpColumn;
        }
        this.accumulator.append(ch);
    }

    private int decodeHexByte(char c1, char c2, int lin, int col) {
        try {
            return JsonParser.decodeHexByte(c1, c2);
        }
        catch (Exception thr) {
            throw this.parserError(6, thr.getMessage(), null, lin, col);
        }
    }

    private int decodeHexChar(char c1, char c2, char c3, char c4, int lin, int col) {
        try {
            return JsonParser.decodeHexChar(c1, c2, c3, c4);
        }
        catch (Exception thr) {
            throw this.parserError(6, thr.getMessage(), null, lin, col);
        }
    }

    private Location createLocation(int lin, int col) {
        return new Location(this.inpName, lin, col, this.mbrName != null && this.mbrName.length() != 0 ? this.mbrName : this.objectData.arrayName);
    }

    private int readChar() throws IOException {
        int ich;
        if (this.pushBack != -1) {
            ich = this.pushBack;
            this.pushBack = -1;
            ++this.inpColumn;
        } else {
            ich = this.inpReader.read();
            if (ich != -1) {
                if (ich == 10) {
                    this.inpColumn = 0;
                    ++this.inpLine;
                } else if (ich == 65279) {
                    ich = 32;
                } else {
                    ++this.inpColumn;
                }
            }
        }
        return ich;
    }

    private void unreadChar(int ich) throws IOException {
        if (ich != -1) {
            if (this.pushBack != -1) {
                throw this.parserError(1, "Cannot unread '" + (char)ich + "' the character '" + (char)this.pushBack + "' is already pending");
            }
            this.pushBack = ich;
            if (ich == 10) {
                this.inpColumn = 0;
                --this.inpLine;
            } else {
                --this.inpColumn;
            }
        }
    }

    private void pushObjectData() {
        this.objectStack.add(this.objectData);
    }

    private void popObjectData() {
        int siz = this.objectStack.size();
        if (siz == 0) {
            throw this.parserError(4, "An extraneous object closing brace was present in the input data");
        }
        if (this.objectData.arrayDepth != 0) {
            throw this.parserError(4, "Array named '" + this.objectData.arrayName + "' was not ended (end of enclosing object was reached before array was ended)");
        }
        this.objectData = this.objectStack.remove(siz - 1);
        this.mbrName = this.objectData.name;
    }

    private String getAccumulatedText(boolean kwd) {
        String val = this.accumulator.toString().trim();
        this.accumulator.setLength(0);
        if (kwd) {
            if (this.optInternKeywords) {
                val = val.intern();
            }
        } else if (this.optInternValues) {
            val = val.intern();
        }
        return val;
    }

    private Escape parserError(int cod, String txt) {
        return this.parserError(cod, txt, null);
    }

    private Escape parserError(int cod, String txt, Throwable thr) {
        return this.parserError(cod, txt, thr, this.inpLine, this.inpColumn);
    }

    private Escape parserError(int cod, String txt, Throwable thr, int lin, int col) {
        return new Escape(cod, txt + "; at " + this.createLocation(lin, col), thr);
    }

    public static Object createTypedValue(String val) {
        if (val.equalsIgnoreCase("null")) {
            return null;
        }
        if (val.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (val.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        if (JsonParser.isQuoted(val)) {
            return JsonParser.stripQuotes(val);
        }
        if (val.length() == 0) {
            return val;
        }
        return new BigDecimal(val);
    }

    public static String getEventName(int cod) {
        if (cod < 1) {
            return EVT_NAMES[0];
        }
        if (cod >= EVT_NAMES.length) {
            return "EVT_" + cod;
        }
        return EVT_NAMES[cod];
    }

    public static String stripQuotes(String val) {
        if (JsonParser.isQuoted(val)) {
            val = val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static boolean isQuoted(String val) {
        char ch0;
        int len;
        return val != null && (len = val.length()) > 1 && ((ch0 = val.charAt(0)) == '\"' || ch0 == '\'') && ch0 == val.charAt(len - 1);
    }

    private static Reader preloadInput(String inpnam, Reader inprdr, boolean inpcls, int sizest) throws Escape {
        char[] buf = new char[10240];
        try {
            int len;
            CharArrayWriter wtr = new CharArrayWriter(sizest > 0 ? sizest : 10240);
            while ((len = inprdr.read(buf)) != -1) {
                wtr.write(buf, 0, len);
            }
            wtr.flush();
            if (inpcls) {
                wtr.close();
            }
            return new CharArrayReader(wtr.toCharArray());
        }
        catch (IOException thr) {
            throw new Escape(2, "Could not read input from \"" + inpnam + "\": " + thr, thr);
        }
    }

    private static int decodeHexByte(char hex1, char hex2) {
        int n2;
        int n1;
        if (hex1 > '\u00ff' || (n1 = decodeHex[hex1]) == -1) {
            throw new RuntimeException("Escape sequence contains the invalid hexadecimal digit '" + hex1 + "'; not 0-9, a-f or A-F");
        }
        if (hex2 > '\u00ff' || (n2 = decodeHex[hex2]) == -1) {
            throw new RuntimeException("Escape sequence contains the invalid hexadecimal digit '" + hex2 + "'; not 0-9, a-f or A-F");
        }
        return n1 << 4 | n2;
    }

    private static int decodeHexChar(char hex1, char hex2, char hex3, char hex4) {
        return JsonParser.decodeHexByte(hex1, hex2) << 8 | JsonParser.decodeHexByte(hex3, hex4);
    }

    static {
        for (int xa = 0; xa < decodeHex.length; ++xa) {
            JsonParser.decodeHex[xa] = -1;
        }
        JsonParser.decodeHex[48] = 0;
        JsonParser.decodeHex[49] = 1;
        JsonParser.decodeHex[50] = 2;
        JsonParser.decodeHex[51] = 3;
        JsonParser.decodeHex[52] = 4;
        JsonParser.decodeHex[53] = 5;
        JsonParser.decodeHex[54] = 6;
        JsonParser.decodeHex[55] = 7;
        JsonParser.decodeHex[56] = 8;
        JsonParser.decodeHex[57] = 9;
        JsonParser.decodeHex[65] = 10;
        JsonParser.decodeHex[66] = 11;
        JsonParser.decodeHex[67] = 12;
        JsonParser.decodeHex[68] = 13;
        JsonParser.decodeHex[69] = 14;
        JsonParser.decodeHex[70] = 15;
        JsonParser.decodeHex[97] = 10;
        JsonParser.decodeHex[98] = 11;
        JsonParser.decodeHex[99] = 12;
        JsonParser.decodeHex[100] = 13;
        JsonParser.decodeHex[101] = 14;
        JsonParser.decodeHex[102] = 15;
    }

    public static class Escape
    extends RuntimeException {
        public static final int GENERAL = 1;
        public static final int IOERROR = 2;
        public static final int BAD_ENCODING = 3;
        public static final int MALFORMED = 4;
        public static final int BAD_ESCAPE = 6;
        public static final int INVALID_STATE = 7;
        public static final int METHOD_ERROR = 8;
        public static final int CONVERSION = 9;
        public static final int SUBCLSMIN = 1000;
        private final int code;

        public Escape(int code, String detail) {
            this(code, detail, null);
        }

        public Escape(int code, String detail, Throwable cause) {
            super(detail, cause);
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }

    static class ObjectData {
        final String name;
        String arrayName;
        int arrayDepth;

        ObjectData(String nam) {
            this.name = nam;
            this.arrayName = "";
            this.arrayDepth = 0;
        }
    }

    public static final class Location {
        private final String inpName;
        private final int inpLine;
        private final int inpCol;
        private final String mbrName;

        Location(String inpnam, int inplin, int inpcol, String mbrnam) {
            this.inpName = inpnam;
            this.inpLine = inplin;
            this.inpCol = inpcol;
            this.mbrName = mbrnam == null || mbrnam.length() == 0 ? null : mbrnam;
        }

        public String toString() {
            if (this.inpCol > 0) {
                return "Input Source: \"" + this.inpName + "\", Line: " + this.inpLine + ", Column: " + this.inpCol + (this.mbrName == null ? "" : ", Member Name: " + this.mbrName);
            }
            return "Input Source: \"" + this.inpName + "\", Line: " + (this.inpLine - 1) + ", Column: EOL" + (this.mbrName == null ? "" : ", Member Name: " + this.mbrName);
        }

        public String getInputSource() {
            return this.inpName;
        }

        public int getInputLine() {
            return this.inpLine;
        }

        public int getInputColumn() {
            return this.inpCol;
        }

        public String getMemberName() {
            return this.mbrName;
        }
    }
}

