/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.Verifier;

public class RecordImpl
implements Record {
    private Long id;
    private Leader leader;
    protected List<ControlField> controlFields = new ArrayList<ControlField>();
    protected List<DataField> dataFields = new ArrayList<DataField>();
    private String type;

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setLeader(Leader leader) {
        this.leader = leader;
    }

    @Override
    public Leader getLeader() {
        return this.leader;
    }

    @Override
    public void addVariableField(VariableField field) {
        String tag = field.getTag();
        if (field instanceof ControlField) {
            ControlField controlField = (ControlField)field;
            if (Verifier.isControlNumberField(tag)) {
                if (Verifier.hasControlNumberField(this.controlFields)) {
                    this.controlFields.set(0, controlField);
                } else {
                    this.controlFields.add(0, controlField);
                }
            } else {
                this.controlFields.add(controlField);
            }
        } else {
            this.dataFields.add((DataField)field);
        }
    }

    @Override
    public void removeVariableField(VariableField field) {
        String tag = field.getTag();
        if (Verifier.isControlField(tag)) {
            this.controlFields.remove(field);
        } else {
            this.dataFields.remove(field);
        }
    }

    @Override
    public ControlField getControlNumberField() {
        if (Verifier.hasControlNumberField(this.controlFields)) {
            return this.controlFields.get(0);
        }
        return null;
    }

    @Override
    public List<ControlField> getControlFields() {
        return this.controlFields;
    }

    @Override
    public List<DataField> getDataFields() {
        return this.dataFields;
    }

    @Override
    public VariableField getVariableField(String tag) {
        Iterator<VariableField> i = Verifier.isControlField(tag) ? this.controlFields.iterator() : this.dataFields.iterator();
        while (i.hasNext()) {
            VariableField field = i.next();
            if (!field.getTag().equals(tag)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<VariableField> getVariableFields(String tag) {
        ArrayList<VariableField> fields = new ArrayList<VariableField>();
        Iterator<VariableField> i = Verifier.isControlField(tag) ? this.controlFields.iterator() : this.dataFields.iterator();
        while (i.hasNext()) {
            VariableField field = i.next();
            if (!field.getTag().equals(tag)) continue;
            fields.add(field);
        }
        return fields;
    }

    @Override
    public List<VariableField> getVariableFields() {
        ArrayList<VariableField> fields = new ArrayList<VariableField>();
        Iterator<VariableField> i = this.controlFields.iterator();
        while (i.hasNext()) {
            fields.add(i.next());
        }
        i = this.dataFields.iterator();
        while (i.hasNext()) {
            fields.add(i.next());
        }
        return fields;
    }

    @Override
    public String getControlNumber() {
        ControlField f = this.getControlNumberField();
        if (f == null || f.getData() == null) {
            return null;
        }
        return f.getData();
    }

    @Override
    public List<VariableField> getVariableFields(String[] tags) {
        ArrayList<VariableField> list = new ArrayList<VariableField>();
        for (int i = 0; i < tags.length; ++i) {
            String tag = tags[i];
            List<VariableField> fields = this.getVariableFields(tag);
            if (fields.size() <= 0) continue;
            list.addAll(fields);
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LEADER ");
        sb.append(this.getLeader().toString());
        sb.append('\n');
        for (VariableField field : this.getVariableFields()) {
            sb.append(field.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<VariableField> find(String pattern) {
        ArrayList<VariableField> result = new ArrayList<VariableField>();
        for (VariableField variableField : this.controlFields) {
            if (!variableField.find(pattern)) continue;
            result.add(variableField);
        }
        for (VariableField variableField : this.dataFields) {
            if (!variableField.find(pattern)) continue;
            result.add(variableField);
        }
        return result;
    }

    @Override
    public List<VariableField> find(String tag, String pattern) {
        ArrayList<VariableField> result = new ArrayList<VariableField>();
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public List<VariableField> find(String[] tag, String pattern) {
        ArrayList<VariableField> result = new ArrayList<VariableField>();
        for (VariableField field : this.getVariableFields(tag)) {
            if (!field.find(pattern)) continue;
            result.add(field);
        }
        return result;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }
}

