/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j.marc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.MarcFactoryImpl;

public abstract class MarcFactory {
    protected MarcFactory() {
    }

    public static MarcFactory newInstance() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = MarcFactory.class.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = MarcFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (MarcFactory)t.newInstance();
            }
            catch (ClassNotFoundException e) {
                className = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (className == null && count < 3);
        return new MarcFactoryImpl();
    }

    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        String propertyName = "org.marc4j.marc.MarcFactory";
        switch (attempt) {
            case 0: {
                return System.getProperty("org.marc4j.marc.MarcFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "marc4j.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("org.marc4j.marc.MarcFactory");
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    String serviceKey = "/META-INF/services/org.marc4j.marc.MarcFactory";
                    InputStream inputStream = in = loader != null ? loader.getResourceAsStream(serviceKey) : MarcFactory.class.getResourceAsStream(serviceKey);
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract ControlField newControlField();

    public abstract ControlField newControlField(String var1);

    public abstract ControlField newControlField(String var1, String var2);

    public abstract DataField newDataField();

    public abstract DataField newDataField(String var1, char var2, char var3);

    public abstract DataField newDataField(String var1, char var2, char var3, String ... var4);

    public abstract Leader newLeader();

    public abstract Leader newLeader(String var1);

    public abstract Record newRecord();

    public abstract Record newRecord(Leader var1);

    public abstract Record newRecord(String var1);

    public abstract Subfield newSubfield();

    public abstract Subfield newSubfield(char var1);

    public abstract Subfield newSubfield(char var1, String var2);

    public boolean validateRecord(Record record) {
        if (record.getLeader() == null) {
            return false;
        }
        for (ControlField controlField : record.getControlFields()) {
            if (this.validateControlField(controlField)) continue;
            return false;
        }
        for (DataField dataField : record.getDataFields()) {
            if (this.validateDataField(dataField)) continue;
            return false;
        }
        return true;
    }

    public boolean validateVariableField(VariableField field) {
        return field.getTag() != null;
    }

    public boolean validateControlField(ControlField field) {
        return this.validateVariableField(field) && field.getData() != null;
    }

    public boolean validateDataField(DataField field) {
        if (!this.validateVariableField(field)) {
            return false;
        }
        if (field.getIndicator1() == '\u0000' || field.getIndicator2() == '\u0000') {
            return false;
        }
        for (Subfield subfield : field.getSubfields()) {
            if (this.validateSubField(subfield)) continue;
            return false;
        }
        return true;
    }

    public boolean validateSubField(Subfield subfield) {
        return subfield.getCode() != '\u0000' && subfield.getData() != null;
    }
}

