/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.marc4j.MarcException;
import org.marc4j.MarcWriter;
import org.marc4j.converter.CharConverter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.MarcFactory;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.util.Normalizer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MarcXmlWriter
implements MarcWriter {
    protected static final String CONTROL_FIELD = "controlfield";
    protected static final String DATA_FIELD = "datafield";
    protected static final String SUBFIELD = "subfield";
    protected static final String COLLECTION = "collection";
    protected static final String RECORD = "record";
    protected static final String LEADER = "leader";
    private boolean indent = false;
    private TransformerHandler handler = null;
    private Writer writer = null;
    private String encoding = "UTF8";
    private CharConverter converter = null;
    private boolean normalize = false;

    public MarcXmlWriter(OutputStream out) {
        this(out, false);
    }

    public MarcXmlWriter(OutputStream out, boolean indent) {
        this(out, "UTF8", indent);
    }

    public MarcXmlWriter(OutputStream out, String encoding) {
        this(out, encoding, false);
    }

    public MarcXmlWriter(OutputStream out, String encoding, boolean indent) {
        this.encoding = encoding;
        if (out == null) {
            throw new NullPointerException("null OutputStream");
        }
        if (this.encoding == null) {
            throw new NullPointerException("null encoding");
        }
        try {
            this.setIndent(indent);
            this.writer = new OutputStreamWriter(out, encoding);
            this.writer = new BufferedWriter(this.writer);
            this.setHandler(new StreamResult(this.writer), null);
        }
        catch (UnsupportedEncodingException e) {
            throw new MarcException(e.getMessage(), e);
        }
        this.writeStartDocument();
    }

    public MarcXmlWriter(Result result) {
        if (result == null) {
            throw new NullPointerException("null Result");
        }
        this.setHandler(result, null);
        this.writeStartDocument();
    }

    public MarcXmlWriter(Result result, String stylesheetUrl) {
        this(result, new StreamSource(stylesheetUrl));
    }

    public MarcXmlWriter(Result result, Source stylesheet) {
        if (stylesheet == null) {
            throw new NullPointerException("null Source");
        }
        if (result == null) {
            throw new NullPointerException("null Result");
        }
        this.setHandler(result, stylesheet);
        this.writeStartDocument();
    }

    @Override
    public void close() {
        this.writeEndDocument();
        try {
            this.writer.write("\n");
            this.writer.close();
        }
        catch (IOException e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    @Override
    public CharConverter getConverter() {
        return this.converter;
    }

    @Override
    public void setConverter(CharConverter converter) {
        this.converter = converter;
    }

    public void setUnicodeNormalization(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean getUnicodeNormalization() {
        return this.normalize;
    }

    protected void setHandler(Result result, Source stylesheet) throws MarcException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            if (!factory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
                throw new UnsupportedOperationException("SAXTransformerFactory is not supported");
            }
            SAXTransformerFactory saxFactory = (SAXTransformerFactory)factory;
            this.handler = stylesheet == null ? saxFactory.newTransformerHandler() : saxFactory.newTransformerHandler(stylesheet);
            this.handler.getTransformer().setOutputProperty("method", "xml");
            this.handler.setResult(result);
        }
        catch (Exception e) {
            throw new MarcException(e.getMessage(), e);
        }
    }

    protected void writeStartDocument() {
        try {
            AttributesImpl atts = new AttributesImpl();
            this.handler.startDocument();
            this.handler.startElement("http://www.loc.gov/MARC21/slim", COLLECTION, COLLECTION, atts);
        }
        catch (SAXException e) {
            throw new MarcException("SAX error occured while writing start document", e);
        }
    }

    protected void writeEndDocument() {
        try {
            if (this.indent) {
                this.handler.ignorableWhitespace("\n".toCharArray(), 0, 1);
            }
            this.handler.endElement("http://www.loc.gov/MARC21/slim", COLLECTION, COLLECTION);
            this.handler.endPrefixMapping("");
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new MarcException("SAX error occured while writing end document", e);
        }
    }

    @Override
    public void write(Record record) {
        try {
            this.toXml(record);
        }
        catch (SAXException e) {
            throw new MarcException("SAX error occured while writing record", e);
        }
    }

    public boolean hasIndent() {
        return this.indent;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    protected void toXml(Record record) throws SAXException {
        if (!MarcFactory.newInstance().validateRecord(record)) {
            throw new MarcException("Marc record didn't validate");
        }
        AttributesImpl atts = new AttributesImpl();
        if (this.indent) {
            this.handler.ignorableWhitespace("\n  ".toCharArray(), 0, 3);
        }
        this.handler.startElement("http://www.loc.gov/MARC21/slim", RECORD, RECORD, atts);
        if (this.indent) {
            this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
        }
        this.handler.startElement("http://www.loc.gov/MARC21/slim", LEADER, LEADER, atts);
        Leader leader = record.getLeader();
        char[] temp = leader.toString().toCharArray();
        this.handler.characters(temp, 0, temp.length);
        this.handler.endElement("http://www.loc.gov/MARC21/slim", LEADER, LEADER);
        for (ControlField controlField : record.getControlFields()) {
            atts = new AttributesImpl();
            atts.addAttribute("", "tag", "tag", "CDATA", controlField.getTag());
            if (this.indent) {
                this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.handler.startElement("http://www.loc.gov/MARC21/slim", CONTROL_FIELD, CONTROL_FIELD, atts);
            temp = this.getDataElement(controlField.getData());
            this.handler.characters(temp, 0, temp.length);
            this.handler.endElement("http://www.loc.gov/MARC21/slim", CONTROL_FIELD, CONTROL_FIELD);
        }
        for (DataField dataField : record.getDataFields()) {
            atts = new AttributesImpl();
            atts.addAttribute("", "tag", "tag", "CDATA", dataField.getTag());
            atts.addAttribute("", "ind1", "ind1", "CDATA", String.valueOf(dataField.getIndicator1()));
            atts.addAttribute("", "ind2", "ind2", "CDATA", String.valueOf(dataField.getIndicator2()));
            if (this.indent) {
                this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.handler.startElement("http://www.loc.gov/MARC21/slim", DATA_FIELD, DATA_FIELD, atts);
            for (Subfield subfield : dataField.getSubfields()) {
                atts = new AttributesImpl();
                atts.addAttribute("", "code", "code", "CDATA", String.valueOf(subfield.getCode()));
                if (this.indent) {
                    this.handler.ignorableWhitespace("\n      ".toCharArray(), 0, 7);
                }
                this.handler.startElement("http://www.loc.gov/MARC21/slim", SUBFIELD, SUBFIELD, atts);
                temp = this.getDataElement(subfield.getData());
                this.handler.characters(temp, 0, temp.length);
                this.handler.endElement("http://www.loc.gov/MARC21/slim", SUBFIELD, SUBFIELD);
            }
            if (this.indent) {
                this.handler.ignorableWhitespace("\n    ".toCharArray(), 0, 5);
            }
            this.handler.endElement("http://www.loc.gov/MARC21/slim", DATA_FIELD, DATA_FIELD);
        }
        if (this.indent) {
            this.handler.ignorableWhitespace("\n  ".toCharArray(), 0, 3);
        }
        this.handler.endElement("http://www.loc.gov/MARC21/slim", RECORD, RECORD);
    }

    protected char[] getDataElement(String data) {
        String dataElement = null;
        dataElement = this.converter == null ? data : this.converter.convert(data);
        if (this.normalize) {
            dataElement = Normalizer.normalize(dataElement, Normalizer.NFC);
        }
        return dataElement.toCharArray();
    }
}

