/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.converter.CharConverter;
import org.marc4j.converter.impl.AnselToUnicode;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.util.Normalizer;

public class MarcTranslatedReader
implements MarcReader {
    MarcReader reader;
    CharConverter convert;
    int unicodeNormalize = Normalizer.NONE;

    public MarcTranslatedReader(MarcReader r, boolean unicodeNormalizeBool) {
        this.reader = r;
        this.convert = new AnselToUnicode();
        if (unicodeNormalizeBool) {
            this.unicodeNormalize = Normalizer.NFC;
        }
    }

    public MarcTranslatedReader(MarcReader r, String unicodeNormalizeStr) {
        this.reader = r;
        this.convert = new AnselToUnicode();
        this.unicodeNormalize = unicodeNormalizeStr.equals("KC") ? Normalizer.NFKC : (unicodeNormalizeStr.equals("KD") ? Normalizer.NFKD : (unicodeNormalizeStr.equals("C") ? Normalizer.NFC : (unicodeNormalizeStr.equals("D") ? Normalizer.NFD : Normalizer.NONE)));
    }

    @Override
    public boolean hasNext() {
        return this.reader.hasNext();
    }

    @Override
    public Record next() {
        Record rec = this.reader.next();
        Leader l = rec.getLeader();
        boolean is_utf_8 = false;
        if (l.getCharCodingScheme() == 'a') {
            is_utf_8 = true;
        }
        if (is_utf_8 && this.unicodeNormalize == Normalizer.NONE) {
            return rec;
        }
        List<VariableField> fields = rec.getVariableFields();
        for (VariableField f : fields) {
            if (!(f instanceof DataField)) continue;
            DataField field = (DataField)f;
            List<Subfield> subfields = field.getSubfields();
            for (Subfield sf : subfields) {
                String oldData;
                String newData = oldData = sf.getData();
                if (!is_utf_8) {
                    newData = this.convert.convert(newData);
                }
                if (this.unicodeNormalize != Normalizer.NONE) {
                    newData = Normalizer.normalize(newData, this.unicodeNormalize);
                }
                if (oldData.equals(newData)) continue;
                sf.setData(newData);
            }
        }
        l.setCharCodingScheme('a');
        rec.setLeader(l);
        return rec;
    }
}

