/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.marc4j.MarcException;
import org.marc4j.MarcStreamWriter;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.DataField;
import org.marc4j.marc.Leader;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;

public class MarcSplitStreamWriter
extends MarcStreamWriter {
    private int recordThreshhold;
    private String fieldsToSplit;

    public MarcSplitStreamWriter(OutputStream out, int threshhold, String fieldsToSplit) {
        super(out, false);
        this.recordThreshhold = threshhold;
        this.fieldsToSplit = fieldsToSplit;
    }

    public MarcSplitStreamWriter(OutputStream out, String encoding, int threshhold, String fieldsToSplit) {
        super(out, encoding, false);
        this.recordThreshhold = threshhold;
        this.fieldsToSplit = fieldsToSplit;
    }

    @Override
    public void write(Record record) {
        boolean doneWithRec = false;
        for (DataField df : record.getDataFields()) {
            if (!df.getTag().matches(this.fieldsToSplit)) continue;
            df.setId(null);
        }
        while (!doneWithRec) {
            try {
                int previous = 0;
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                ByteArrayOutputStream dir = new ByteArrayOutputStream();
                for (ControlField cf : record.getControlFields()) {
                    data.write(this.getDataElement(cf.getData()));
                    data.write(30);
                    dir.write(this.getEntry(cf.getTag(), data.size() - previous, previous));
                    previous = data.size();
                }
                for (DataField df : record.getDataFields()) {
                    if (df.getTag().matches(this.fieldsToSplit)) continue;
                    data.write(df.getIndicator1());
                    data.write(df.getIndicator2());
                    for (Subfield sf : df.getSubfields()) {
                        data.write(31);
                        data.write(sf.getCode());
                        data.write(this.getDataElement(sf.getData()));
                    }
                    data.write(30);
                    dir.write(this.getEntry(df.getTag(), data.size() - previous, previous));
                    previous = data.size();
                }
                doneWithRec = true;
                for (DataField df : record.getDataFields()) {
                    if (previous >= this.recordThreshhold) {
                        doneWithRec = false;
                        break;
                    }
                    if (!df.getTag().matches(this.fieldsToSplit) || df.getId() != null && df.getId().intValue() == 0) continue;
                    df.setId(new Long(0L));
                    data.write(df.getIndicator1());
                    data.write(df.getIndicator2());
                    for (Subfield sf : df.getSubfields()) {
                        data.write(31);
                        data.write(sf.getCode());
                        data.write(this.getDataElement(sf.getData()));
                    }
                    data.write(30);
                    dir.write(this.getEntry(df.getTag(), data.size() - previous, previous));
                    previous = data.size();
                }
                dir.write(30);
                Leader ldr = record.getLeader();
                int baseAddress = 24 + dir.size();
                ldr.setBaseAddressOfData(baseAddress);
                int recordLength = ldr.getBaseAddressOfData() + data.size() + 1;
                ldr.setRecordLength(recordLength);
                dir.close();
                data.close();
                if (!this.allowOversizeEntry && this.hasOversizeLength) {
                    throw new MarcException("Record has field that is too long to be a valid MARC binary record. The maximum length for a field counting all of the sub-fields is 9999 bytes.");
                }
                this.writeLeader(ldr);
                this.out.write(dir.toByteArray());
                this.out.write(data.toByteArray());
                this.out.write(29);
            }
            catch (IOException e) {
                throw new MarcException("IO Error occured while writing record", e);
            }
            catch (MarcException e) {
                throw e;
            }
        }
    }
}

