/*
 * Decompiled with CFR 0.152.
 */
package org.marc4j;

import java.util.LinkedList;
import java.util.List;

public class ErrorHandler {
    public static final int FATAL = 4;
    public static final int MAJOR_ERROR = 3;
    public static final int MINOR_ERROR = 2;
    public static final int ERROR_TYPO = 1;
    public static final int INFO = 0;
    private List errors = null;
    private String curRecordID;
    private String curField;
    private String curSubfield;
    private boolean hasMissingID = false;
    private int maxSeverity = 0;

    private String getSeverityMsg(int severity) {
        switch (severity) {
            case 4: {
                return "FATAL       ";
            }
            case 3: {
                return "Major Error ";
            }
            case 2: {
                return "Minor Error ";
            }
            case 1: {
                return "Typo        ";
            }
            case 0: {
                return "Info        ";
            }
        }
        return null;
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0 && this.maxSeverity > 0;
    }

    public int getMaxSeverity() {
        return this.maxSeverity;
    }

    public List getErrors() {
        if (this.errors == null || this.errors.size() == 0) {
            return null;
        }
        return this.errors;
    }

    public void reset() {
        this.errors = null;
        this.maxSeverity = 0;
    }

    public void addError(String id, String field, String subfield, int severity, String message) {
        if (this.errors == null) {
            this.errors = new LinkedList();
            this.hasMissingID = false;
        }
        if (id != null && id.equals("unknown")) {
            this.hasMissingID = true;
        } else if (this.hasMissingID) {
            this.setRecordIDForAll(id);
        }
        this.errors.add(new Error(id, field, subfield, severity, message));
        if (severity > this.maxSeverity) {
            this.maxSeverity = severity;
        }
    }

    public void addError(int severity, String message) {
        this.addError(this.curRecordID, this.curField, this.curSubfield, severity, message);
    }

    public void addErrors(List newErrors) {
        if (newErrors == null || newErrors.size() == 0) {
            return;
        }
        if (this.errors == null) {
            this.errors = new LinkedList();
            this.hasMissingID = false;
        }
        for (Object err : newErrors) {
            Error errobj = (Error)err;
            this.errors.add(errobj);
            if (errobj.severity <= this.maxSeverity) continue;
            this.maxSeverity = errobj.severity;
        }
    }

    private void setRecordIDForAll(String id) {
        if (id != null) {
            for (Error err : this.errors) {
                if (err.getCurRecordID() != null && !err.getCurRecordID().equals("unknown")) continue;
                err.setCurRecordID(id);
            }
            this.hasMissingID = false;
        }
    }

    public void setRecordID(String recordID) {
        this.curRecordID = recordID;
        if (this.hasMissingID && this.errors != null) {
            this.setRecordIDForAll(recordID);
        }
    }

    public void setCurrentField(String curField) {
        this.curField = curField;
    }

    public void setCurrentSubfield(String curSubfield) {
        this.curSubfield = curSubfield;
    }

    public class Error {
        public String curRecordID;
        public String curField;
        public String curSubfield;
        public int severity;
        public String message;

        protected Error(String recordID, String field, String subfield, int severity, String message) {
            this.curRecordID = recordID;
            this.curField = field;
            this.curSubfield = subfield;
            this.severity = severity;
            this.message = message;
        }

        public String toString() {
            String severityMsg = ErrorHandler.this.getSeverityMsg(this.severity);
            String ret = severityMsg + " : " + this.message + " --- [ " + this.curField + " : " + this.curSubfield + " ]";
            return ret;
        }

        private void setCurRecordID(String curRecordID) {
            this.curRecordID = curRecordID;
        }

        private String getCurRecordID() {
            return this.curRecordID;
        }
    }
}

