/*
 * Decompiled with CFR 0.152.
 */
package org.grouplens.lenskit.gradle;

import com.google.common.collect.FluentIterable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Nullable;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.TaskAction;
import org.grouplens.lenskit.gradle.LenskitExtension;

public class LenskitEval
extends DefaultTask {
    private JavaExec exec;
    private Object script = "eval.groovy";
    private List<String> targets = new ArrayList<String>();
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Integer threadCount;
    private Object classpath;

    public LenskitEval() {
        this.exec = new JavaExec();
    }

    public void setProject(Project project) {
        this.exec.setProject(project);
        super.setProject(project);
    }

    public void script(Object obj) {
        this.script = obj;
    }

    public void setScript(Object obj) {
        this.script = obj;
    }

    public Object getScript() {
        return this.script;
    }

    public void targets(String ... tgts) {
        for (String t : tgts) {
            this.targets.add(t);
        }
    }

    public void setTargets(Iterable<String> tgts) {
        this.targets = FluentIterable.from(tgts).toList();
    }

    public List<String> getTargets() {
        return this.targets;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> props) {
        this.properties = new HashMap<String, Object>(props);
    }

    public void properties(Map<String, Object> props) {
        this.properties.putAll(props);
    }

    @Nullable
    private LenskitExtension getLenskitConfig() {
        return (LenskitExtension)this.getProject().getExtensions().findByName("lenskit");
    }

    public int getThreadCount() {
        if (this.threadCount != null) {
            return this.threadCount;
        }
        LenskitExtension ext = this.getLenskitConfig();
        if (ext != null) {
            return ext.getThreadCount();
        }
        return 0;
    }

    public void setThreadCount(int tc) {
        this.threadCount = tc;
    }

    public void threadCount(int tc) {
        this.setThreadCount(tc);
    }

    @InputFile
    public File getScriptFile() {
        return this.getProject().file(this.script);
    }

    @TaskAction
    public void exec() {
        this.exec.setMain("org.grouplens.lenskit.cli.Main");
        this.exec.args(new Object[]{"eval"});
        this.exec.args(new Object[]{"-j" + this.getThreadCount()});
        for (Map.Entry<String, Object> props : this.properties.entrySet()) {
            this.exec.args(new Object[]{"-D" + props.getKey() + "=" + props.getValue()});
        }
        File f = this.getScriptFile();
        if (f != null) {
            this.exec.args(new Object[]{"-f", f});
        }
        this.exec.args(this.getTargets());
        this.exec.exec();
    }

    public List<String> getAllJvmArgs() {
        return this.exec.getAllJvmArgs();
    }

    public void setAllJvmArgs(Iterable<?> arguments) {
        this.exec.setAllJvmArgs(arguments);
    }

    public List<String> getJvmArgs() {
        return this.exec.getJvmArgs();
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.exec.setJvmArgs(arguments);
    }

    public JavaExec jvmArgs(Iterable<?> arguments) {
        return this.exec.jvmArgs(arguments);
    }

    public JavaExec jvmArgs(Object ... arguments) {
        return this.exec.jvmArgs(arguments);
    }

    public Map<String, Object> getSystemProperties() {
        return this.exec.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ?> properties) {
        this.exec.setSystemProperties(properties);
    }

    public JavaExec systemProperty(String name, Object value) {
        return this.exec.systemProperty(name, value);
    }

    public JavaExec systemProperties(Map<String, ?> properties) {
        return this.exec.systemProperties(properties);
    }

    @InputFiles
    public FileCollection getBootstrapClasspath() {
        return this.exec.getBootstrapClasspath();
    }

    public JavaExec bootstrapClasspath(Object ... classpath) {
        return this.exec.bootstrapClasspath(classpath);
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.exec.setBootstrapClasspath(classpath);
    }

    public String getMinHeapSize() {
        return this.exec.getMinHeapSize();
    }

    public void setMinHeapSize(String heapSize) {
        this.exec.setMinHeapSize(heapSize);
    }

    public String getMaxHeapSize() {
        return this.exec.getMaxHeapSize();
    }

    public void setMaxHeapSize(String heapSize) {
        this.exec.setMaxHeapSize(heapSize);
    }

    public String getDefaultCharacterEncoding() {
        return this.exec.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.exec.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public boolean getEnableAssertions() {
        return this.exec.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.exec.setEnableAssertions(enabled);
    }

    public JavaExec classpath(Object ... paths) {
        return this.exec.classpath(paths);
    }

    public JavaExec setClasspath(FileCollection classpath) {
        return this.exec.setClasspath(classpath);
    }

    @InputFiles
    public FileCollection getClasspath() {
        return this.exec.getClasspath();
    }

    public File getWorkingDir() {
        return this.exec.getWorkingDir();
    }

    public void setWorkingDir(Object dir) {
        this.exec.setWorkingDir(dir);
    }

    public JavaExec workingDir(Object dir) {
        return this.exec.workingDir(dir);
    }

    public Map<String, Object> getEnvironment() {
        return this.exec.getEnvironment();
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.exec.setEnvironment(environmentVariables);
    }

    public JavaExec environment(String name, Object value) {
        return this.exec.environment(name, value);
    }

    public JavaExec environment(Map<String, ?> environmentVariables) {
        return this.exec.environment(environmentVariables);
    }
}

